
* RUN THIS CODE AFTER RUNNING THE RDP_variable_definition_code SCRIPT.


********** Investor policy
gen plac_x = .
drop plac*
gen plac1Aq_up1CI = .
gen plac1Aq_up5CI = .
gen plac1Aq_coef = .
gen plac1Aq_lw5CI = .
gen plac1Aq_lw1CI = .
forvalues q = 200(1)238 {
	gen plac_`q' = 0
	replace plac_`q' = 1 if qtr == `q'
	quietly xtabond dl_inv plac_`q' lcapitalratio lfunding GDP houseprice qtr_dum* ///
		if policy1_qnt_banks == 1, lags(2) vce(robust)
	lincom plac_`q'
	replace plac1Aq_up1CI = r(estimate) + invnormal(0.995)*r(se) if qtr == `q'
	replace plac1Aq_up5CI = r(estimate) + invnormal(0.975)*r(se) if qtr == `q'
	replace plac1Aq_coef = r(estimate) if qtr == `q'
	replace plac1Aq_lw5CI = r(estimate) + invnormal(0.025)*r(se) if qtr == `q'
	replace plac1Aq_lw1CI = r(estimate) + invnormal(0.005)*r(se) if qtr == `q'
}
tsline plac1Aq_up1CI plac1Aq_coef plac1Aq_lw1CI if qtr >= 198 & qtr <= 300, sort ///
	lcolor(black black black) lpattern(shortdash solid shortdash) lwidth(thin medium thin) ///
	yline(0) legend(order(2 "coefficient on quarterly indicator" 1 "95% confidence interval")) ///
	xtick(200(4)238, tlength(2)) tlabel(200(4)238, format(%tqCY)) xtitle("") 
*Majors
gen plac_x = .
drop plac_*
gen plac1Mq_up1CI = .
gen plac1Mq_up5CI = .
gen plac1Mq_coef = .
gen plac1Mq_lw5CI = .
gen plac1Mq_lw1CI = .
forvalues q = 200(1)238 {
	gen plac_`q' = 0
	replace plac_`q' = 1 if qtr == `q'
	quietly xtabond dl_inv plac_`q' lcapitalratio lfunding GDP houseprice qtr_dum* ///
		if MajorBank == 1, lags(2) vce(robust)
	lincom plac_`q'
	replace plac1Mq_up1CI = r(estimate) + invnormal(0.995)*r(se) if qtr == `q'
	replace plac1Mq_up5CI = r(estimate) + invnormal(0.975)*r(se) if qtr == `q'
	replace plac1Mq_coef = r(estimate) if qtr == `q'
	replace plac1Mq_lw5CI = r(estimate) + invnormal(0.025)*r(se) if qtr == `q'
	replace plac1Mq_lw1CI = r(estimate) + invnormal(0.005)*r(se) if qtr == `q'
}
tsline plac1Mq_up5CI plac1Mq_coef plac1Mq_lw5CI if qtr >= 198 & qtr <= 300, sort ///
	lcolor(black black black) lpattern(shortdash solid shortdash) lwidth(thin medium thin) ///
	yline(0) legend(order(2 "coefficient on quarterly indicator" 1 "95% confidence interval")) ///
	xtick(200(4)238, tlength(2)) tlabel(200(4)238, format(%tqCY)) xtitle("") 
*Nonmajors	
gen plac_x = .
drop plac_*
gen plac1Nq_up1CI = .
gen plac1Nq_up5CI = .
gen plac1Nq_coef = .
gen plac1Nq_lw5CI = .
gen plac1Nq_lw1CI = .
forvalues q = 200(1)238 {
	gen plac_`q' = 0
	replace plac_`q' = 1 if qtr == `q'
	quietly xtabond dl_inv plac_`q' lcapitalratio lfunding GDP houseprice qtr_dum* ///
		if policy1_qnt_banks == 1 & MajorBank == 0, lags(2) vce(robust)
	lincom plac_`q'
	replace plac1Nq_up1CI = r(estimate) + invnormal(0.995)*r(se) if qtr == `q'
	replace plac1Nq_up5CI = r(estimate) + invnormal(0.975)*r(se) if qtr == `q'
	replace plac1Nq_coef = r(estimate) if qtr == `q'
	replace plac1Nq_lw5CI = r(estimate) + invnormal(0.025)*r(se) if qtr == `q'
	replace plac1Nq_lw1CI = r(estimate) + invnormal(0.005)*r(se) if qtr == `q'
}
tsline plac1Nq_up5CI plac1Nq_coef plac1Nq_lw5CI if qtr >= 198 & qtr <= 300, sort ///
	lcolor(black black black) lpattern(shortdash solid shortdash) lwidth(thin medium thin) ///
	yline(0) legend(order(2 "coefficient on quarterly indicator" 1 "95% confidence interval")) ///
	xtick(200(4)238, tlength(2)) tlabel(200(4)238, format(%tqCY)) xtitle("") 

*Placebo tests for investor interest rates
*All
gen plac_x = .
drop plac_*
gen plac1Ap_up1CI = .
gen plac1Ap_up5CI = .
gen plac1Ap_coef = .
gen plac1Ap_lw5CI = .
gen plac1Ap_lw1CI = .
forvalues q = 200(1)238 {
	gen plac_`q' = 0
	replace plac_`q' = 1 if qtr == `q'
	quietly reghdfe d_diff_spread_invpi plac_`q' lcapitalratio lfunding l(0/1).dcashrate GDP houseprice qtr_dum* ///
	if policy1_int_banks == 1, absorb(bank) vce(cluster bank qtr)
	lincom plac_`q'
	replace plac1Ap_up1CI = r(estimate) + invnormal(0.995)*r(se) if qtr == `q'
	replace plac1Ap_up5CI = r(estimate) + invnormal(0.975)*r(se) if qtr == `q'
	replace plac1Ap_coef = r(estimate) if qtr == `q'
	replace plac1Ap_lw5CI = r(estimate) + invnormal(0.025)*r(se) if qtr == `q'
	replace plac1Ap_lw1CI = r(estimate) + invnormal(0.005)*r(se) if qtr == `q'
}
tsline plac1Ap_up5CI plac1Ap_coef plac1Ap_lw5CI if qtr >= 198 & qtr <= 300, sort ///
	lcolor(black black black) lpattern(shortdash solid shortdash) lwidth(thin medium thin) ///
	yline(0) legend(order(2 "coefficient on quarterly indicator" 1 "95% confidence interval")) ///
	xtick(200(4)238, tlength(2)) tlabel(200(4)238, format(%tqCY)) xtitle("") 
*Majors
gen plac_x = .
drop plac_*
gen plac1Mp_up1CI = .
gen plac1Mp_up5CI = .
gen plac1Mp_coef = .
gen plac1Mp_lw5CI = .
gen plac1Mp_lw1CI = .
forvalues q = 200(1)238 {
	gen plac_`q' = 0
	replace plac_`q' = 1 if qtr == `q'
	quietly reghdfe d_diff_spread_invpi plac_`q' lcapitalratio lfunding l(0/1).dcashrate GDP houseprice qtr_dum* ///
	if MajorBank == 1, absorb(bank) vce(cluster qtr)
	lincom plac_`q'
	replace plac1Mp_up1CI = r(estimate) + invnormal(0.995)*r(se) if qtr == `q'
	replace plac1Mp_up5CI = r(estimate) + invnormal(0.975)*r(se) if qtr == `q'
	replace plac1Mp_coef = r(estimate) if qtr == `q'
	replace plac1Mp_lw5CI = r(estimate) + invnormal(0.025)*r(se) if qtr == `q'
	replace plac1Mp_lw1CI = r(estimate) + invnormal(0.005)*r(se) if qtr == `q'
}
tsline plac1Mp_up5CI plac1Mp_coef plac1Mp_lw5CI if qtr >= 198 & qtr <= 300, sort ///
	lcolor(black black black) lpattern(shortdash solid shortdash) lwidth(thin medium thin) ///
	yline(0) legend(order(2 "coefficient on quarterly indicator" 1 "95% confidence interval")) ///
	xtick(200(4)238, tlength(2)) tlabel(200(4)238, format(%tqCY)) xtitle("") 
*Nonmajors
gen plac_x = .
drop plac_*
gen plac1Np_up1CI = .
gen plac1Np_up5CI = .
gen plac1Np_coef = .
gen plac1Np_lw5CI = .
gen plac1Np_lw1CI = .
forvalues q = 200(1)238 {
	gen plac_`q' = 0
	replace plac_`q' = 1 if qtr == `q'
	quietly reghdfe d_diff_spread_invpi plac_`q' lcapitalratio lfunding l(0/1).dcashrate GDP houseprice qtr_dum* ///
	if policy1_int_banks == 1 & MajorBank == 0, absorb(bank) vce(cluster bank qtr)
	lincom plac_`q'
	replace plac1Np_up1CI = r(estimate) + invnormal(0.995)*r(se) if qtr == `q'
	replace plac1Np_up5CI = r(estimate) + invnormal(0.975)*r(se) if qtr == `q'
	replace plac1Np_coef = r(estimate) if qtr == `q'
	replace plac1Np_lw5CI = r(estimate) + invnormal(0.025)*r(se) if qtr == `q'
	replace plac1Np_lw1CI = r(estimate) + invnormal(0.005)*r(se) if qtr == `q'
}
tsline plac1Np_up5CI plac1Np_coef plac1Np_lw5CI if qtr >= 198 & qtr <= 300, sort ///
	lcolor(black black black) lpattern(shortdash solid shortdash) lwidth(thin medium thin) ///
	yline(0) legend(order(2 "coefficient on quarterly indicator" 1 "95% confidence interval")) ///
	xtick(200(4)238, tlength(2)) tlabel(200(4)238, format(%tqCY)) xtitle("") 

* Export data (same for all banks so just export one)
outsheet period plac1* if bank == "CBA" using "placebo_results_Inv_policy.csv", comma
	
	
********** IO policy
gen plac_x = .
drop plac*
gen plac2Aq_up1CI = .
gen plac2Aq_up5CI = .
gen plac2Aq_coef = .
gen plac2Aq_lw5CI = .
gen plac2Aq_lw1CI = .
forvalues q = 200(1)238 {
	gen plac_`q' = 0
	replace plac_`q' = 1 if qtr == `q'
	quietly xtabond dl_TotalIO plac_`q' lcapitalratio lfunding GDP houseprice qtr_dum* ///
		if policy2_qnt_banks == 1, lags(2) vce(robust)
	lincom plac_`q'
	replace plac2Aq_up1CI = r(estimate) + invnormal(0.995)*r(se) if qtr == `q'
	replace plac2Aq_up5CI = r(estimate) + invnormal(0.975)*r(se) if qtr == `q'
	replace plac2Aq_coef = r(estimate) if qtr == `q'
	replace plac2Aq_lw5CI = r(estimate) + invnormal(0.025)*r(se) if qtr == `q'
	replace plac2Aq_lw1CI = r(estimate) + invnormal(0.005)*r(se) if qtr == `q'
}
tsline plac2Aq_up1CI plac2Aq_coef plac2Aq_lw1CI if qtr >= 198 & qtr <= 300, sort ///
	lcolor(black black black) lpattern(shortdash solid shortdash) lwidth(thin medium thin) ///
	yline(0) legend(order(2 "coefficient on quarterly indicator" 1 "95% confidence interval")) ///
	xtick(200(4)238, tlength(2)) tlabel(200(4)238, format(%tqCY)) xtitle("") 
*Majors
gen plac_x = .
drop plac_*
gen plac2Mq_up1CI = .
gen plac2Mq_up5CI = .
gen plac2Mq_coef = .
gen plac2Mq_lw5CI = .
gen plac2Mq_lw1CI = .
forvalues q = 200(1)238 {
	gen plac_`q' = 0
	replace plac_`q' = 1 if qtr == `q'
	quietly xtabond dl_TotalIO plac_`q' lcapitalratio lfunding GDP houseprice qtr_dum* ///
		if MajorBank == 1, lags(2) vce(robust)
	lincom plac_`q'
	replace plac2Mq_up1CI = r(estimate) + invnormal(0.995)*r(se) if qtr == `q'
	replace plac2Mq_up5CI = r(estimate) + invnormal(0.975)*r(se) if qtr == `q'
	replace plac2Mq_coef = r(estimate) if qtr == `q'
	replace plac2Mq_lw5CI = r(estimate) + invnormal(0.025)*r(se) if qtr == `q'
	replace plac2Mq_lw1CI = r(estimate) + invnormal(0.005)*r(se) if qtr == `q'
}
tsline plac2Mq_up5CI plac2Mq_coef plac2Mq_lw5CI if qtr >= 198 & qtr <= 300, sort ///
	lcolor(black black black) lpattern(shortdash solid shortdash) lwidth(thin medium thin) ///
	yline(0) legend(order(2 "coefficient on quarterly indicator" 1 "95% confidence interval")) ///
	xtick(200(4)238, tlength(2)) tlabel(200(4)238, format(%tqCY)) xtitle("") 
*Nonmajors	
gen plac_x = .
drop plac_*
gen plac2Nq_up1CI = .
gen plac2Nq_up5CI = .
gen plac2Nq_coef = .
gen plac2Nq_lw5CI = .
gen plac2Nq_lw1CI = .
forvalues q = 200(1)238 {
	gen plac_`q' = 0
	replace plac_`q' = 1 if qtr == `q'
	quietly xtabond dl_TotalIO plac_`q' lcapitalratio lfunding GDP houseprice qtr_dum* ///
		if policy2_qnt_banks == 1 & MajorBank == 0, lags(2) vce(robust)
	lincom plac_`q'
	replace plac2Nq_up1CI = r(estimate) + invnormal(0.995)*r(se) if qtr == `q'
	replace plac2Nq_up5CI = r(estimate) + invnormal(0.975)*r(se) if qtr == `q'
	replace plac2Nq_coef = r(estimate) if qtr == `q'
	replace plac2Nq_lw5CI = r(estimate) + invnormal(0.025)*r(se) if qtr == `q'
	replace plac2Nq_lw1CI = r(estimate) + invnormal(0.005)*r(se) if qtr == `q'
}
tsline plac2Nq_up5CI plac2Nq_coef plac2Nq_lw5CI if qtr >= 198 & qtr <= 300, sort ///
	lcolor(black black black) lpattern(shortdash solid shortdash) lwidth(thin medium thin) ///
	yline(0) legend(order(2 "coefficient on quarterly indicator" 1 "95% confidence interval")) ///
	xtick(200(4)238, tlength(2)) tlabel(200(4)238, format(%tqCY)) xtitle("") 

*Placebo tests for IO IO IO IO IO interest rates
*All
gen plac_x = .
drop plac_*
gen plac2Ap_up1CI = .
gen plac2Ap_up5CI = .
gen plac2Ap_coef = .
gen plac2Ap_lw5CI = .
gen plac2Ap_lw1CI = .
forvalues q = 200(1)238 {
	gen plac_`q' = 0
	replace plac_`q' = 1 if qtr == `q'
	quietly reghdfe d_diff_spread_invio plac_`q' lcapitalratio lfunding l(0/1).dcashrate GDP houseprice qtr_dum* ///
	if policy2_int_banks == 1, absorb(bank) vce(cluster bank qtr)
	lincom plac_`q'
	replace plac2Ap_up1CI = r(estimate) + invnormal(0.995)*r(se) if qtr == `q'
	replace plac2Ap_up5CI = r(estimate) + invnormal(0.975)*r(se) if qtr == `q'
	replace plac2Ap_coef = r(estimate) if qtr == `q'
	replace plac2Ap_lw5CI = r(estimate) + invnormal(0.025)*r(se) if qtr == `q'
	replace plac2Ap_lw1CI = r(estimate) + invnormal(0.005)*r(se) if qtr == `q'
}
tsline plac2Ap_up5CI plac2Ap_coef plac2Ap_lw5CI if qtr >= 198 & qtr <= 300, sort ///
	lcolor(black black black) lpattern(shortdash solid shortdash) lwidth(thin medium thin) ///
	yline(0) legend(order(2 "coefficient on quarterly indicator" 1 "95% confidence interval")) ///
	xtick(200(4)238, tlength(2)) tlabel(200(4)238, format(%tqCY)) xtitle("") 
*Majors
gen plac_x = .
drop plac_*
gen plac2Mp_up1CI = .
gen plac2Mp_up5CI = .
gen plac2Mp_coef = .
gen plac2Mp_lw5CI = .
gen plac2Mp_lw1CI = .
forvalues q = 200(1)238 {
	gen plac_`q' = 0
	replace plac_`q' = 1 if qtr == `q'
	quietly reghdfe d_diff_spread_invio plac_`q' lcapitalratio lfunding l(0/1).dcashrate GDP houseprice qtr_dum* ///
	if MajorBank == 1, absorb(bank) vce(cluster qtr)
	lincom plac_`q'
	replace plac2Mp_up1CI = r(estimate) + invnormal(0.995)*r(se) if qtr == `q'
	replace plac2Mp_up5CI = r(estimate) + invnormal(0.975)*r(se) if qtr == `q'
	replace plac2Mp_coef = r(estimate) if qtr == `q'
	replace plac2Mp_lw5CI = r(estimate) + invnormal(0.025)*r(se) if qtr == `q'
	replace plac2Mp_lw1CI = r(estimate) + invnormal(0.005)*r(se) if qtr == `q'
}
tsline plac2Mp_up5CI plac2Mp_coef plac2Mp_lw5CI if qtr >= 198 & qtr <= 300, sort ///
	lcolor(black black black) lpattern(shortdash solid shortdash) lwidth(thin medium thin) ///
	yline(0) legend(order(2 "coefficient on quarterly indicator" 1 "95% confidence interval")) ///
	xtick(200(4)238, tlength(2)) tlabel(200(4)238, format(%tqCY)) xtitle("") 
*Nonmajors
gen plac_x = .
drop plac_*
gen plac2Np_up1CI = .
gen plac2Np_up5CI = .
gen plac2Np_coef = .
gen plac2Np_lw5CI = .
gen plac2Np_lw1CI = .
forvalues q = 200(1)238 {
	gen plac_`q' = 0
	replace plac_`q' = 1 if qtr == `q'
	quietly reghdfe d_diff_spread_invio plac_`q' lcapitalratio lfunding l(0/1).dcashrate GDP houseprice qtr_dum* ///
	if policy2_int_banks == 1 & MajorBank == 0, absorb(bank) vce(cluster bank qtr)
	lincom plac_`q'
	replace plac2Np_up1CI = r(estimate) + invnormal(0.995)*r(se) if qtr == `q'
	replace plac2Np_up5CI = r(estimate) + invnormal(0.975)*r(se) if qtr == `q'
	replace plac2Np_coef = r(estimate) if qtr == `q'
	replace plac2Np_lw5CI = r(estimate) + invnormal(0.025)*r(se) if qtr == `q'
	replace plac2Np_lw1CI = r(estimate) + invnormal(0.005)*r(se) if qtr == `q'
}
tsline plac2Np_up5CI plac2Np_coef plac2Np_lw5CI if qtr >= 198 & qtr <= 300, sort ///
	lcolor(black black black) lpattern(shortdash solid shortdash) lwidth(thin medium thin) ///
	yline(0) legend(order(2 "coefficient on quarterly indicator" 1 "95% confidence interval")) ///
	xtick(200(4)238, tlength(2)) tlabel(200(4)238, format(%tqCY)) xtitle("") 

* Export data (same for all banks so just export one)
outsheet period plac2* if bank == "CBA" using "placebo_results_IO_policy.csv", comma

	
